/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_1799;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

@FunctionalInterface
public interface EntryComparator<T> {
    public static <T> EntryComparator<T> noop() {
        return (context, stack) -> 1L;
    }

    public static EntryComparator<class_1799> itemComponents() {
        EntryComparator<class_9323> componentHasher = EntryComparator.component(new class_9331[0]);
        return (context, stack) -> componentHasher.hash(context, stack.method_57353());
    }

    public static EntryComparator<FluidStack> fluidComponents() {
        EntryComparator<class_9323> componentHasher = EntryComparator.component(new class_9331[0]);
        return (context, stack) -> 0L;
    }

    public static EntryComparator<class_9323> component(class_9331<?> ... ignoredKeys) {
        return Internals.getComponentHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, T var2);

    default public EntryComparator<T> onlyExact() {
        EntryComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public EntryComparator<T> then(EntryComparator<T> other) {
        Objects.requireNonNull(other);
        EntryComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

